Scriptname WitcherMeditateWaitMCMQuestScript extends SKI_ConfigBase

Int Property MeditateHotKey auto hidden
Int SetKey
Bool Property Issleep = false auto hidden
Int Sleepmode
Bool Property IsSouls = false auto hidden
Int Souls



Event onconfiginit()
	Pages = new string[2]
	Pages[0] = "$Hotkey Set"
	Pages[1] = "$Toggle Sleep"
endevent


event OnPageReset(string page)
	if page == "$Hotkey Set"
		SetCursorFillMode(LEFT_TO_RIGHT) 
		SetKey = AddKeyMapOption("$Meditate Hotkey", MeditateHotKey)
	endif
	if page == "$Toggle Sleep"
		Sleepmode = AddToggleOption("$Sleep Meditation",Issleep)
	endif	
	if page == "$Compability Settings"
		Souls = AddToggleOption("$SkyrimSouls", IsSouls)
	endif	
endevent

event OnOptionSelect(int option)
	if option == Sleepmode
		if Issleep == false
			Issleep = true
		else 
			Issleep = false		
		endif
		SetToggleOptionValue(Sleepmode, Issleep)
	endIf
	if option == Souls
		if IsSouls == false
			IsSouls = true
		else 
			IsSouls = false		
		endif
		SetToggleOptionValue(Souls, IsSouls)
	endIf	
endevent	


event OnOptionKeyMapChange(int option, int keyCode, string conflictControl, string conflictName)
	if option == SetKey
			bool continue = true
		if (conflictControl != "")
			string msg
			if (conflictName != "")
				msg = "This key is already mapped to:\n\"" + conflictControl + GetCustomControl(keyCode) + "\"\n(" + conflictName + ")\n\nAre you sure you want to continue?"
			else
				msg = "This key is already mapped to:\n\"" + conflictControl + GetCustomControl(keyCode) + "\"\n\nAre you sure you want to continue?"
			endIf

			continue = ShowMessage(msg, true, "$Yes", "$No")
		endIf

		if (continue)
		MeditateHotKey = keyCode
		SetKeyMapOptionValue(SetKey, MeditateHotKey)
		endif
	endIf
	endEvent	
	
event OnOptionHighlight(int option)
	if option == Sleepmode
		SetInfoText("$Check the box to set the meditate waiting into meditate sleeping. Must Disable the Save on Rest in settings if checked.")
	endif	
	if option == SetKey 	
		SetInfoText("$Press to set the hotkey of enter meditation")
	endIf
endEvent
	
Event OnConfigClose()
	UnregisterForAllKeys()
	if MeditateHotKey != 1
		RegisterForKey(MeditateHotKey)
	endif	
EndEvent

string function GetCustomControl(int keyCode)
	if (keyCode == SetKey)
		return "$Meditate Hotkey"
	else
		return ""
	endIf
endFunction